#Árvores binárias de pesquisa com registos, equilibradas pela chave

def emptyreg():
    return []
def treereg(rt,key,lab,lt):
    return [rt,key,lab,lt]

def emptyQreg(atree):
    return atree==[]

def leafQreg(atree):
    return not emptyQreg(atree) and emptyQreg(leftreg(atree)) and emptyQreg(rightreg(atree))

def leftreg(atree):
    assert not emptyQreg(atree) 
    return atree[0] 
def keyreg(atree):
    assert not emptyQreg(atree) 
    return atree[1]
def labelreg(atree):
    assert not emptyQreg(atree) 
    return atree[2]
def rightreg(atree):
    assert not emptyQreg(atree) 
    return atree[3]

def isBinTreeQreg(atree):
    if emptyQreg(atree):
        return True
    else:
        return isinstance(atree,list) and len(atree)==4 and isBinTreeQreg(leftreg(atree)) and isBinTreeQreg(rightreg(atree))

def cardinalreg(atree):
    if emptyQreg(atree):
        return 0
    else:
        return 1+ cardinalreg(leftreg(atree)) + cardinalreg(rightreg(atree))
    
def treeSearchKeyregQ(x,atree):
    if emptyQreg(atree):
        return False
    else:
        return x==keyreg(atree) or treeSearchKeyregQ(x,leftreg(atree)) or treeSearchKeyregQ(x,rightreg(atree))

def depthfirstreg(atree):
    if emptyQreg(atree):
        return []
    else:
        return depthfirstreg(leftreg(atree))+[(keyreg(atree),labelreg(atree))]+depthfirstreg(rightreg(atree))

def breadthfirstreg(atree):
    toprocess=[atree] 
    rlist=[]
    while toprocess!=[]:
        presentnode=toprocess[0]
        toprocess=toprocess[1:]
        if not emptyQreg(presentnode):
            rlist=rlist+[(keyreg(presentnode),labelreg(presentnode))] 
            toprocess=toprocess+[leftreg(presentnode),rightreg(presentnode)] 
    return rlist         

def minimumreg(atree):
    assert not emptyQreg(atree)
    if emptyQreg(leftreg(atree)):
        return keyreg(atree),labelreg(atree)
    else:
        return minimumreg(leftreg(atree))
    
def maximumreg(atree):
    assert not emptyQreg(atree)
    if emptyQreg(rightreg(atree)):
        return keyreg(atree),labelreg(atree)
    else:
        return maximumreg(rightreg(atree))
    
def keysearchQreg(k,atree):
    if emptyQreg(atree):
        return False
    elif k==keyreg(atree):
        return True
    elif k<keyreg(atree):
        return keysearchQreg(k,leftreg(atree))
    else:
        return keysearchQreg(k,rightreg(atree))  
    
def keyFindQreg(k,atree):
    if emptyQreg(atree):
        return None
    elif k==keyreg(atree):
        return labelreg(atree)
    elif k<keyreg(atree):
        return keyFindQreg(k,leftreg(atree))
    else:
        return keyFindQreg(k,rightreg(atree))

def insreg(k,r,t):
    if emptyQreg(t):
        return treereg(emptyreg(),k,r,emptyreg())
    elif k<keyreg(t):
        return treereg(insreg(k,r,leftreg(t)),keyreg(t),labelreg(t),rightreg(t))
    else:
        return treereg(leftreg(t), keyreg(t),labelreg(t), insreg(k,r,rightreg(t)))
    
def deltreg(x,t):
    if emptyQreg(t):
        return t
    elif x<keyreg(t):
        return treereg(deltreg(x,leftreg(t)),keyreg(t),labelreg(t),rightreg(t))
    elif x>keyreg(t):
        return treereg(leftreg(t), keyreg(t), labelreg(t), deltreg(x,rightreg(t)))
    else:
        if emptyQreg(leftreg(t)):
            return rightreg(t)
        elif  emptyQreg(rightreg(t)):
            return leftreg(t)
        else:
            minkey,minreg=minimumreg(rightreg(t))
            return treereg(leftreg(t),minkey,minreg,deltreg(minkey,rightreg(t)))

def heightreg(atree):
    if emptyQreg(atree):
        return -1
    else:
        return 1+max(heightreg(rightreg(atree)),heightreg(leftreg(atree)))

def balancedQreg(atree):
    if emptyQreg(atree):
        return True
    else:
        return abs(heightreg(rightreg(atree))-heightreg(leftreg(atree)))<=1 and balancedQreg(rightreg(atree)) and balancedQreg(leftreg(atree))

def balanceLLreg(atree):
    yk=keyreg(atree)
    yr=labelreg(atree)
    gama=rightreg(atree)
    xk=keyreg(leftreg(atree))
    xr=labelreg(leftreg(atree))
    alfa=leftreg(leftreg(atree))
    beta=rightreg(leftreg(atree))
    return treereg(alfa, xk,xr, treereg(beta,yk,yr,gama))

def balanceRRreg(atree):
    xk=keyreg(atree)
    xr=labelreg(atree)
    alfa=leftreg(atree)
    yk=keyreg(rightreg(atree))
    yr=labelreg(rightreg(atree))
    beta=leftreg(rightreg(atree))
    gama=rightreg(rightreg(atree))
    return treereg(treereg(alfa,xk,xr,beta),yk,yr,gama)
        
def balanceLRreg(atree):
    yk=keyreg(atree)
    yr=labelreg(atree)
    gama=rightreg(atree)
    xk=keyreg(leftreg(atree))
    xr=labelreg(leftreg(atree))
    alfa=leftreg(leftreg(atree))
    bk=keyreg(rightreg(leftreg(atree)))
    br=labelreg(rightreg(leftreg(atree)))
    beta1=leftreg(rightreg(leftreg(atree)))
    beta2=rightreg(rightreg(leftreg(atree)))
    return treereg(treereg(alfa,xk,xr,beta1),bk,br,treereg(beta2,yk,yr,gama))
                   
def balanceRLreg(atree):
    xk=keyreg(atree)
    xr=labelreg(atree)
    alfa=leftreg(atree)
    yk=keyreg(rightreg(atree))
    yr=labelreg(rightreg(atree))
    gama=rightreg(rightreg(atree))
    bk=keyreg(leftreg(rightreg(atree)))
    br=labelreg(leftreg(rightreg(atree)))
    beta1=leftreg(leftreg(rightreg(atree)))
    beta2=rightreg(leftreg(rightreg(atree)))
    return treereg(treereg(alfa,xk,xr,beta1),bk,br,treereg(beta2,yk,yr,gama))
                   
def balancereg(atree):
    if emptyQreg(atree):
        return atree
    else:
        if balancedQreg(leftreg(atree)):
            ltree=leftreg(atree)
        else:
            ltree=balancereg(leftreg(atree))              
        if balancedQreg(rightreg(atree)):
            rtree=rightreg(atree)
        else:
            rtree=balancereg(rightreg(atree))
        if abs(heightreg(ltree)-heightreg(rtree))<=1:
            return treereg(ltree,keyreg(atree),labelreg(atree),rtree)
        elif heightreg(ltree)>heightreg(rtree):
            if heightreg(leftreg(ltree))>heightreg(rightreg(ltree)):
                return balanceLLreg(atree)
            else:
                return balanceLRreg(atree)
        else:
            if heightreg(leftreg(rtree))>heightreg(rightreg(rtree)):
                return balanceRLreg(atree)
            else:
                 return balanceRRreg(atree)
                   
def insertreg(x,r,atree):
    return balancereg(insreg(x,r,atree))
                 
def deletereg(x,atree):
    return balancereg(deltreg(x,atree))

def showKeysreg(a):
    h=heightreg(a)
    space=2**(h+1)
    toprocess=[[a,0]] # tree and line number, starting in line 0
    line=0
    lines=["" for i in range(h+2)]  # lines initialized with ""
    while line<=h:
        presentnode=toprocess[0]
        line=presentnode[1]
        toprocess=toprocess[1:]
        if emptyQreg(presentnode[0]):
            val='.'
            toprocess=toprocess+[[presentnode[0],presentnode[1]+1],[presentnode[0],presentnode[1]+1]]
        else:
            val=str(keyreg(presentnode[0]))
            toprocess=toprocess+[[leftreg(presentnode[0]),presentnode[1]+1],[rightreg(presentnode[0]),presentnode[1]+1]]
        lspace=space/(2**(line+1))-len(val)
        rspace=space/(2**(line+1))
        lines[presentnode[1]]=lines[presentnode[1]]+" "*int(lspace) + val + " "*int(rspace)
    print ('\n'.join(v for v in lines[:-1])) # print the lines

    
 