# Árvores binárias e árvores binárias de pesquisa

def empty():
    return []
def tree(rt,lab,lt):
    return [rt,lab,lt]

def emptyQ(atree):
    return atree==[]
def leafQ(atree):
    return not emptyQ(atree) and emptyQ(left(atree)) and emptyQ(right(atree))

def left(atree):
    assert not emptyQ(atree) 
    return atree[0] 
def label(atree):
    assert not emptyQ(atree) 
    return atree[1]
def right(atree):
    assert not emptyQ(atree) 
    return atree[2]

def isBinTreeQ(atree):
    if emptyQ(atree):
        return True
    else:
        return isinstance(atree,list) and len(atree)==3 and isBinTreeQ(left(atree)) and isBinTreeQ(right(atree))

def cardinal(atree):
    if emptyQ(atree):
        return 0
    else:
        return 1+ cardinal(left(atree)) + cardinal(right(atree))
    
def treeMemberQ(x,atree):
    if emptyQ(atree):
        return False
    else:
        return x==label(atree) or treeMemberQ(x,left(atree)) or treeMemberQ(x,right(atree))    
    
def depthfirst(atree):
    if emptyQ(atree):
        return []
    else:
        return depthfirst(left(atree)) +[label(atree)]+depthfirst(right(atree))
    
def breadthfirst(atree):
    toprocess=[atree]  
    rlist=[]
    while toprocess!=[]:
        presentnode=toprocess[0]
        toprocess=toprocess[1:]
        if not emptyQ(presentnode):
            rlist=rlist+[label(presentnode)]
            toprocess=toprocess+[left(presentnode),right(presentnode)]  
    return rlist                                                    

def maximum(atree):
    assert not emptyQ(atree) 
    if emptyQ(right(atree)):
        return label(atree)
    else:
        return maximum(right(atree))
    
def minimum(atree):
    assert not emptyQ(atree)
    if emptyQ(left(atree)):
        return label(atree)
    else:
        return minimum(left(atree))
    
def memberQ(x,atree):
    if emptyQ(atree):
        return False
    elif x==label(atree):
        return True
    elif x<label(atree):
        return memberQ(x,left(atree))
    else:
        return memberQ(x,right(atree))
    
def ins(x,t):
    if emptyQ(t):
        return tree(empty(),x,empty())
    elif x<label(t):
        return tree(ins(x,left(t)),label(t),right(t))
    else:
        return tree(left(t), label(t), ins(x,right(t)))
    
def delt(x,t):
    if emptyQ(t):
        return t
    elif x<label(t):
        return tree(delt(x,left(t)),label(t),right(t))
    elif x>label(t):
        return tree(left(t), label(t), delt(x,right(t)))
    else:
        if emptyQ(left(t)):
            return right(t)
        elif  emptyQ(right(t)):
            return left(t)
        else:
            mini=minimum(right(t))
            return tree(left(t),mini,delt(mini,right(t)))
        
def height(atree):
    if emptyQ(atree):
        return -1
    else:
        return 1+max(height(right(atree)),height(left(atree)))
    
def balancedQ(atree):
    if emptyQ(atree):
        return True
    else:
        return abs(height(right(atree))-height(left(atree)))<=1 and balancedQ(right(atree)) and balancedQ(left(atree))
    
def balanceLL(atree):
    y=label(atree)
    gama=right(atree)
    x=label(left(atree))
    alfa=left(left(atree))
    beta=right(left(atree))
    return tree(alfa, x, tree(beta,y,gama))

def balanceRR(atree):
    x=label(atree)
    alfa=left(atree)
    y=label(right(atree))
    beta=left(right(atree))
    gama=right(right(atree))
    return tree(tree(alfa,x,beta),y,gama)

def balanceLR(atree):
    y=label(atree)
    gama=right(atree)
    x=label(left(atree))
    alfa=left(left(atree))
    b=label(right(left(atree)))
    beta1=left(right(left(atree)))
    beta2=right(right(left(atree)))
    return tree(tree(alfa,x,beta1),b,tree(beta2,y,gama))

def balanceRL(atree):
    x=label(atree)
    alfa=left(atree)
    y=label(right(atree))
    gama=right(right(atree))
    b=label(left(right(atree)))
    beta1=left(left(right(atree)))
    beta2=right(left(right(atree)))
    return tree(tree(alfa,x,beta1),b,tree(beta2,y,gama))

def balance(atree):
    if emptyQ(atree):
        return atree
    else:
        if balancedQ(left(atree)):
            ltree=left(atree)
        else:
            ltree=balance(left(atree))   
            
        if balancedQ(right(atree)):
            rtree=right(atree)
        else:
            rtree=balance(right(atree))
        if abs(height(ltree)-height(rtree))<=1:
            return tree(ltree,label(atree),rtree)
        elif height(ltree)>height(rtree):
            if height(left(ltree))>height(right(ltree)):
                return balanceLL(atree)
            else:
                return balanceLR(atree)
        else:
            if height(left(rtree))>height(right(rtree)):
                return balanceRL(atree)
            else:
                 return balanceRR(atree)

def insert(x,atree):
    return balance(ins(x,atree))

def delete(x,atree):
    return balance(delt(x,atree))

def show(a):
    h=height(a)
    space=2**(h+1)
    toprocess=[[a,0]] # tree and line number, starting in line 0
    line=0
    lines=["" for i in range(h+2)]  # lines initialized with ""
    while line<=h:
        presentnode=toprocess[0]
        line=presentnode[1]
        toprocess=toprocess[1:]
        if emptyQ(presentnode[0]):
            val='.'
            toprocess=toprocess+[[presentnode[0],presentnode[1]+1],[presentnode[0],presentnode[1]+1]]
        else:
            val=str(label(presentnode[0]))
            toprocess=toprocess+[[left(presentnode[0]),presentnode[1]+1],[right(presentnode[0]),presentnode[1]+1]]
        lspace=space/(2**(line+1))-len(val)
        rspace=space/(2**(line+1))
        lines[presentnode[1]]=lines[presentnode[1]]+" "*int(lspace) + val + " "*int(rspace)
    print ('\n'.join(v for v in lines[:-1])) # print the lines